<?php
function salvar_auditoria(PDO $pdo, array $data): void {
    $ip_address = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';

    $stmt = $pdo->prepare("
        INSERT INTO loyalty_audit_logs (
            action, table_name, record_id, cpf, user_id, ip_address,
            user_agent, payload_before, payload_after, created_at
        ) VALUES (
            :action, :table_name, :record_id, :cpf, :user_id, :ip_address,
            :user_agent, :payload_before, :payload_after, NOW()
        )
    ");

    $stmt->execute([
        ':action'         => $data['action'],
        ':table_name'     => $data['table'],
        ':record_id'      => $data['record_id'],
        ':cpf'            => $data['cpf'] ?? null,
        ':user_id'        => $data['user_id'] ?? null,
        ':ip_address'     => $ip_address,
        ':user_agent'     => $user_agent,
        ':payload_before' => $data['payload_before'] ?? null,
        ':payload_after'  => $data['payload_after'] ?? null,
    ]);
}


?>