<?php
/**
 * Geocodifica um endereço usando a API Nominatim do OpenStreetMap.
 *
 * @param string $address O endereço completo a ser geocodificado.
 * @return array Um array associativo com as chaves 'latitude' e 'longitude'.
 * @throws Exception Se ocorrer um erro na requisição ou nenhum resultado for encontrado.
 */
function geocodeAddressNominatim($address) {
    // Codifica o endereço para uso na URL
    $encodedAddress = urlencode($address);

    // Monta a URL da API com formato JSON e limita o retorno a 1 resultado
    $url = "https://nominatim.openstreetmap.org/search?q={$encodedAddress}&format=json&limit=1";

    // Configura as opções do contexto, incluindo um User-Agent válido (obrigatório pelo Nominatim)
    $options = [
        "http" => [
            "header" => "User-Agent: MyApp/1.0 (contato@meudominio.com)\r\n"
        ]
    ];
    $context = stream_context_create($options);

    // Realiza a requisição GET para a API
    $responseJson = file_get_contents($url, false, $context);
    if ($responseJson === false) {
        throw new Exception("Erro ao chamar a API Nominatim.");
    }

    // Decodifica o JSON retornado
    $response = json_decode($responseJson, true);
    if (!$response || count($response) === 0) {
        throw new Exception("Nenhum resultado encontrado para o endereço.");
    }

    // Considera o primeiro resultado e extrai as coordenadas
    $location = $response[0];
    return [
        "latitude" => $location["lat"],
        "longitude" => $location["lon"]
    ];
}

// Exemplo de uso:
$enderecoCompleto = "Av. Paulista, 37 - Paraíso, São Paulo - SP, 01311-000";



try {
    $coords = geocodeAddressNominatim($enderecoCompleto);
    echo "Latitude: " . $coords['latitude'] . "\n";
    echo "Longitude: " . $coords['longitude'] . "\n";
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}


?>