<?php
header('Content-Type: application/json');
require_once 'inc_db.php'; // conexão PDO: $pdo

// Lê o corpo da requisição
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Valida se veio JSON válido
if (!$data || !is_array($data)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'JSON inválido ou ausente.']);
    exit;
}

// Extrai e valida os parâmetros esperados
$required = ['loyalty_id', 'loyalty_transaction_id', 'type', 'amount_consumer', 'amount_affiliate'];
foreach ($required as $field) {
    if (!isset($data[$field])) {
        http_response_code(422);
        echo json_encode(['success' => false, 'message' => "Campo obrigatório ausente: $field"]);
        exit;
    }
}

// Prepara e executa a inserção
try {
    $stmt = $pdo->prepare("
        INSERT INTO update54_MUYTO_v2.loyalty_redemptions 
        (loyalty_id, loyalty_transaction_id, type, amount_consumer, amount_affiliate, created_at, updated_at)
        VALUES (:loyalty_id, :loyalty_transaction_id, :type, :amount_consumer, :amount_affiliate, NOW(), NOW())
    ");

    $stmt->execute([
        ':loyalty_id'           => $data['loyalty_id'],
        ':loyalty_transaction_id' => $data['loyalty_transaction_id'],
        ':type'                 => $data['type'],
        ':amount_consumer'     => $data['amount_consumer'],
        ':amount_affiliate'    => $data['amount_affiliate'],
    ]);

    $id = $pdo->lastInsertId();
    echo json_encode(['success' => true, 'message' => 'Resgate registrado com sucesso.', 'id' => $id]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao registrar resgate.',
        'error'   => $e->getMessage()
    ]);
}
